using System;

class Program
{
    const float preciznost = 0.000001f;

    class Trkac
    {
        public float Brzina { get; private set; }
        public float Pozicija { get; private set; }

        public Trkac(float pozicija, float brzina)
        {
            Brzina = brzina;
            Pozicija = pozicija;
        }

        public float VremeDoPozicije(float pozicija)
        {
            return (pozicija - Pozicija) / Brzina;
        }

        public float NovaPozicija(float vreme)
        {
            return Pozicija + vreme * Brzina;
        }
    }

    static uint BrojPreticanjaNaPoziciji(uint brojTrkaca, Trkac[] trkaci, float pozicija)
    {
        var preticanja = 0u;
        var vreme = trkaci[0].VremeDoPozicije(pozicija);

        for(int i = 0; i < brojTrkaca; i++)
        {
            var pozicijaTrenutnog = trkaci[i].NovaPozicija(vreme);
            for(int j = i + 1; j < brojTrkaca; j++)
            {
                var pozicijaNovog = trkaci[j].NovaPozicija(vreme);
                if ((pozicijaTrenutnog - pozicijaNovog) >= 0)
                {
                    preticanja++;
                }
            }
        }

        return preticanja;
    }

    static float VremeDoPreticanja(uint brojTrkaca, Trkac[] trkaci, uint brojPreticanja)
    {
        var levi = 0f;
        var desni = float.MaxValue;
        var resenje = float.MaxValue;
        var nulti = trkaci[0];

        while ((desni - levi) > preciznost)
        {
            var srednji = (desni - levi) / 2 + levi;
            var preticanja = BrojPreticanjaNaPoziciji(brojTrkaca, trkaci, srednji);

            if (preticanja < brojPreticanja)
            {
                levi = srednji + preciznost;
            }
            else
            {
                desni = srednji - preciznost;
            }

            resenje = nulti.VremeDoPozicije(srednji);
        }

        return resenje;
    }

    static void Main()
    {
        var dimenzija = Console.ReadLine().Split(' ');
        var brojTrkaca = uint.Parse(dimenzija[0]);
        var brojPreticanja = uint.Parse(dimenzija[1]);

        var trkaci = new Trkac[brojTrkaca];
        for(int i = 0; i < brojTrkaca; i++)
        {
            var podaci = Console.ReadLine().Split(' ');
            trkaci[i] = new Trkac(float.Parse(podaci[0]), float.Parse(podaci[1]));
        }

        var resenje = VremeDoPreticanja(brojTrkaca, trkaci, brojPreticanja);
        Console.WriteLine(resenje.ToString(".000000000"));
    }
}